#include "MaterialManager.h"
#include <iostream>


namespace PhysicsEngine
{

MaterialManager* MaterialManager::instance = 0;


MaterialManager::MaterialManager()
{
}

MaterialManager* MaterialManager::GetInstance()
{
	if (instance==0)
		instance =  new MaterialManager();
	return instance;
}

void MaterialManager::RegisterMaterial(DataMaterial data)
{
	materials.push_back(data);
}

DataMaterial *MaterialManager::GetDataMaterial(int id)
{
	std::list<DataMaterial>::iterator iter;
	DataMaterial *matptr=0;
	bool found= false;
	iter = materials.begin();
	while (!found && iter!=materials.end())
	{
		if ((*iter).GetId()==id)
		{
			found = true;
			matptr = &(*iter);			
		}
		else
			iter++;
	}
	
	return matptr;
}

void MaterialManager::RegisterInteraction(int idmaterial1, int idmaterial2, DataInteraction data)
{
	stringstream mat1;
	mat1<< idmaterial1;
	stringstream mat2;
	mat2<< idmaterial2;
	string key1 = mat1.str() + "|" + mat2.str();
	string key2 = mat2.str() + "|" + mat1.str();
	interactions.insert(make_pair(key1,data));
	interactions.insert(make_pair(key2,data));
}

DataInteraction MaterialManager::GetDataInteraction(int idmaterial1, int idmaterial2)
{
	stringstream mat1;
	mat1<< idmaterial1;
	stringstream mat2;
	mat2<< idmaterial2;
	string key1 = mat1.str() + "|" + mat2.str();
	string key2 = mat2.str() + "|" + mat1.str();
	bool found = false;
	DataInteraction dataint;
	map<string, DataInteraction>::iterator it;
	
	if (interactions.find(key1)!=interactions.end())
	{
		found = true;
		it = interactions.find(key1);
		
	}
	else if (interactions.find(key2)!=interactions.end())
	{
		found = true;
		it = interactions.find(key2);
	}
	if (found==true)
	{
		dataint.SetHardness(it->second.GetHardness());
		dataint.SetBounciness(it->second.GetBounciness());
		dataint.SetSlip1(it->second.GetSlip1());
		dataint.SetSlip2(it->second.GetSlip2());
		dataint.SetFriction(it->second.GetFriction());
	}
	else
	{
		ConfigurationServer *conf = ConfigurationServer::GetInstance();
		dataint.SetHardness(conf->GetDefaultHardnessInteraction());
		dataint.SetBounciness(conf->GetDefaultBouncinessInteraction());
		dataint.SetSlip1(conf->GetDefaultSlip1Interaction());
		dataint.SetSlip2(conf->GetDefaultSlip2Interaction());
		dataint.SetFriction(conf->GetDefaultFrictionInteraction());
	}
	return dataint;
}


}
